


********************************************************
*** WAVE 4
********************************************************

clear
set more off

use "Dataset/WV4_Data_Stata_v20180912.dta", clear

*** Delete Irrelevant Countries
*Algeria, Iraq, Jordan, Morocco, Egypt
drop if !(inlist(V2, 12, 368, 400, 504, 818))


keep V2 V164 V167 V245 V246
** V164 for V127 in W6 but sligthly different
** V167 for V130 in W6 and V151 in W5
** V140 of W6 is missing in W4


rename V246 year
rename V245 weight
recode V167 (-10/0=.) (1=4) (2=3) (3=2) (4=1) (5/.=.), gen(havingdem)
recode V164 (-10/0=.) (5/.=.), gen(strongleader)

gen country = ""
replace country = "Algeria" if V2==12
replace country = "Iraq" if V2==368
replace country = "Jordan" if V2==400
replace country = "Morocco" if V2==504
replace country = "Egypt" if V2==818

gen wave = 4

save "Wave4.dta", replace



********************************************************
*** WAVE 6
********************************************************

clear
set more off

use "Dataset/WV6_Data_Stata_v20180912.dta", clear

*** Delete Irrelevant Countries
*Algeria, Palestine, Iraq, Jordan, Kuwait, Lebanon, Libya, Morocco, Qatar, Tunisia, Egypt, Yemen
drop if !(inlist(V2, 12, 275, 368, 400, 414, 422, 434, 504, 634, 788, 818, 887))


*** Focus on support for democracy variables
keep V2 V127 V130 V140 V258 V262

*** Rename and recode variables
rename V262 year
rename V258 weight
recode V127 (-10/0=.) (5/.=.), gen(strongleader)
recode V130 (-10/0=.) (1=4) (2=3) (3=2) (4=1) (5/.=.), gen(havingdem)
recode V140 (-10/0=.) (11/.=.) , gen(demimportance)

gen country = ""
replace country = "Algeria" if V2==12
replace country = "Palestine" if V2==275
replace country = "Iraq" if V2==368
replace country = "Jordan" if V2==400
replace country = "Kuwait" if V2==414
replace country = "Lebanon" if V2==422
replace country = "Libya" if V2==434
replace country = "Morocco" if V2==504
replace country = "Qatar" if V2==634
replace country = "Tunisia" if V2==788
replace country = "Egypt" if V2==818
replace country = "Yemen" if V2==887

gen wave = 6

save "Wave6.dta", replace


********************************************************
*** WAVE 5
********************************************************


clear
set more off

use "Dataset/WV5_Data_Stata_v20180912.dta", clear


*** Delete Irrelevant Countries
drop if !(inlist(V2, 364, 368, 400, 504, 818))

*** Focus on support for democracy variables
keep V2 V151 V162 V259 V260

*** Rename and recode variables
rename V260 year
rename V259 weight
recode V151 (-10/0=.) (1=4) (2=3) (3=2) (4=1) (5/.=.), gen(havingdem)
recode V162 (-10/0=.) (11/.=.) , gen(demimportance)

gen country = ""
replace country = "Iran" if V2==364
replace country = "Iraq" if V2==368
replace country = "Jordan" if V2==400
replace country = "Morocco" if V2==504
replace country = "Egypt" if V2==818

gen wave = 5

append using wave6.dta
append using wave4.dta


*Keep only variables present in both waves
keep country havingdem demimportance weight wave year

*Keep only countries present in both waves
keep if inlist(country, "Algeria", "Egypt", "Iraq", "Jordan", "Morocco")

*Which country surveyed in what years
tab year country

rm "wave6.dta"
rm "wave4.dta"

********************************************************
*** Having Democracy is Good
********************************************************

reg havingdem i.wave if country=="Algeria"
margins, at(wave=(4)) post
estimates store Algeria_2002
reg havingdem i.wave if country=="Algeria"
margins, at(wave=(6)) post
estimates store Algeria_2014

reg havingdem i.wave if country=="Egypt"
margins, at(wave=(4)) post
estimates store Egypt_2001
reg havingdem i.wave if country=="Egypt"
margins, at(wave=(5)) post
estimates store Egypt_2008
reg havingdem i.wave if country=="Egypt"
margins, at(wave=(6)) post
estimates store Egypt_2012

reg havingdem i.wave if country=="Iraq"
margins, at(wave=(4)) post
estimates store Iraq_2004
reg havingdem i.wave if country=="Iraq"
margins, at(wave=(5)) post
estimates store Iraq_2006
reg havingdem i.wave if country=="Iraq"
margins, at(wave=(6)) post
estimates store Iraq_2013

reg havingdem i.wave if country=="Jordan"
margins, at(wave=(4)) post
estimates store Jordan_2001
reg havingdem i.wave if country=="Jordan"
margins, at(wave=(5)) post
estimates store Jordan_2007
reg havingdem i.wave if country=="Jordan"
margins, at(wave=(6)) post
estimates store Jordan_2014

reg havingdem i.wave if country=="Morocco"
margins, at(wave=(4)) post
estimates store Morocco_2001
reg havingdem i.wave if country=="Morocco"
margins, at(wave=(5)) post
estimates store Morocco_2007
reg havingdem i.wave if country=="Morocco"
margins, at(wave=(6)) post
estimates store Morocco_2011


grstyle init
grstyle set imesh, compact
graph set window fontface "Garamond"


coefplot (Algeria_2002, mlabels2(_cons=5 "Algeria 2002") mcolor(edkblue) ciopts(lcolor(edkblue))) ///
		 (Algeria_2014, mlabels2(_cons=5 "Algeria 2014") mcolor(edkblue) ciopts(lcolor(edkblue))) ///
		 (Egypt_2001, mlabels2(_cons=5 "Egypt 2001") mcolor(cranberry) ciopts(lcolor(cranberry))) ///
		 (Egypt_2008, mlabels2(_cons=5 "Egypt 2008") mcolor(cranberry) ciopts(lcolor(cranberry))) ///
		 (Egypt_2012, mlabels2(_cons=5 "Egypt 2012 ") mcolor(cranberry) ciopts(lcolor(cranberry))) ///
		 (Iraq_2004, mlabels2(_cons=5 "Iraq 2004") mcolor(edkblue) ciopts(lcolor(edkblue))) ///
		 (Iraq_2006, mlabels2(_cons=5 "Iraq 2006") mcolor(edkblue) ciopts(lcolor(edkblue))) ///
		 (Iraq_2013, mlabels2(_cons=5 "Iraq 2013") mcolor(edkblue) ciopts(lcolor(edkblue))) ///
		 (Jordan_2001, mlabels2(_cons=5 "Jordan 2001") mcolor(cranberry) ciopts(lcolor(cranberry))) ///
		 (Jordan_2007, mlabels2(_cons=5 "Jordan 2007") mcolor(cranberry) ciopts(lcolor(cranberry))) ///
		 (Jordan_2014, mlabels2(_cons=5 "Jordan 2014") mcolor(cranberry) ciopts(lcolor(cranberry))), ///
		 xtitle(Having Democracy is a Good Thing (WVS), tstyle(size(small))) legend(off) ///
		 xscale(range(3 4)) xlabel(3(.2)4) ///
		 coeflabel(_cons = " ") ///
		 mlabcolor(black)
graph export "Figure5.png", width(1000) replace		

graph set window fontface default


